 ; Ŀ
 ;   Lea - leading caps batch utility.                                     
 ;   Larn - do various things to layer name case, some of them sensible.   
 ;   Copyright 2003, 2005, 2009 by Rocket Software Ltd.                    
 ;   Is any taxidermist good enough to do balloon animals?                 
 ; 

 ; Ŀ
 ;   Alta - Capitalise every second character in a text string.            
 ;   Arguments: Exstr, a string.                                           
 ;   Returns the modified string.                                          
 ;   Calls nothing.                                                        
 ; 
 (DEFUN ALTA (exstr / nustr sub caflag)
  (setq nustr "")
  (while (and (setq sub (substr exstr 1 1))
              (/= sub ""))
         (setq exstr (substr exstr 2))
         (setq nustr (strcat nustr (strcase sub caflag)))
         (setq caflag (if caflag nil t)))
 nustr)
 ; Ŀ
 ;   Alta end.                                                             
 ; 

 ; Ŀ
 ;   Conso - Capitalise only the consonants in a text string.              
 ;   Arguments: Exstr, a string.                                           
 ;   Returns the modified string.                                          
 ;   Calls nothing.                                                        
 ; 
 (DEFUN CONSO (exstr / nustr sub)
  (setq nustr "")
  (while (and (setq sub (substr exstr 1 1))
              (/= sub ""))
         (setq exstr (substr exstr 2))
         (if (not (member sub '(list "a" "e" "i" "o" "u" "y"
                                     "A" "E" "I" "O" "U" "Y")))
             (setq nustr (strcat nustr (strcase sub)))
             (setq nustr (strcat nustr (strcase sub t)))))
 nustr)
 ; Ŀ
 ;   Conso end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Fdash - add initial capitals to a text string.             
 ;   Split a string at any character in a list, capitalise each resulting  
 ;   substring, reassemble the string.                                     
 ;   Also watches for certain special cases.                               
 ;   Arguments: Astr: the string to process.                               
 ;              Chra: the list of separator characters.                    
 ;   Recursive.                                                            
 ; 
 (DEFUN FDASH (chra astr / sub prlist nustra nump)
  (if (and astr 
           (car chra)
           (> (length (setq prlist (splat (car chra) astr))) 0))
      (progn
           (setq nustra "")
           (while (setq sub (car prlist))
                  (setq prlist (cdr prlist))
                  (setq sub (strcase sub t))
                  (cond ((= (substr sub 1 1) "(")               ; balance: )
                         (setq sub (strcat "(" (car (hug (substr sub 2)))))) ;)
                        ((or (and (> (setq nump (sonar "." sub t)) 0)
                                  (/= (substr sub (strlen sub)) "."))
                             (> nump 1))
                         (setq sub (strcase sub)))
                        ((member sub '("vsat" "mds" "vavcu"))
                         (setq sub (strcase sub)))
                        (T (setq sub (car (hug sub)))))
                  (setq sub (fdash (cdr chra) sub))             ; recurse
                  (setq nustra (strcat nustra (car chra) sub)))
           (if (= (substr nustra 1 1) (car chra))
               (setq nustra (substr nustra 2))))
      (setq nustra astr))
 nustra)
 ; Ŀ
 ;   Fdash.                                                                
 ; 

 ; Ŀ
 ;   Hug - string capitaliser.  Takes one argument, a string, and returns  
 ;   a list: the string with the first letter changed to upper case and    
 ;   T if this changed the string, () if not.                              
 ; 
 (DEFUN HUG (exstr / nustr)
  (setq nustr (strcat (strcase (substr exstr 1 1))
                      (strcase (substr exstr 2) t)))
 (list nustr (if (= exstr nustr) () t)))
 ; Ŀ
 ;   Hug end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Larke: see whether a button is selected.                   
 ;   If so then return the key of the selected radio button.               
 ;   Otherwise display an error message.                                   
 ;   The Ok button setq a Reason of two numbers: a 2 immediately followed  
 ;   by a 1.  They are sent sequentially - the 2 doesn't block the 1.      
 ; 
 (DEFUN LARKE (reason / phase retlst)
 ; Ŀ
 ;   See if a button was selected.                                         
 ; 
  (cond ((= "1" (get_tile "leading"))
         (setq phase "leading"))
        ((= "1" (get_tile "upper"))
         (setq phase "upper"))
        ((= "1" (get_tile "lower"))
         (setq phase "lower"))
        ((= "1" (get_tile "consonants"))
         (setq phase "consonants"))
        ((= "1" (get_tile "vowels"))
         (setq phase "vowels"))
        ((= "1" (get_tile "alternating"))
         (setq phase "alternating")))
 ; Ŀ
 ;   Decide what to return.                                                
 ; 
  (cond ((or (null phase) (= "" phase))
         (set_tile "babtext" "No Style Selected."))
        ((and phase (/= "" phase) (= reason 1))
         (setq retlst phase)
         (done_dialog))
        ((and phase (/= "" phase))
         (set_tile "babtext" "")
         (setq retlst ())))
 retlst)
 ; Ŀ
 ;   Larke end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Larne - call a dialog box to phase and No. of circuits.    
 ;   Calls Larke.                                                          
 ; 
 (DEFUN LARNE (/ palst)
  (setq dcl_id (load_dialog "larn.dcl"))
  (new_dialog "larn" dcl_id)                 ; must come before data for box
  (action_tile "leading"     "(larke nil)")
  (action_tile "upper"       "(larke nil)")
  (action_tile "lower"       "(larke nil)")
  (action_tile "consonants"  "(larke nil)")
  (action_tile "vowels"      "(larke nil)")
  (action_tile "alternating" "(larke nil)")
  (action_tile "select_ok"     "(setq palst (larke 1))")
  (action_tile "editcancel"  "(setq palst ())")
  (start_dialog)
  (unload_dialog dcl_id)
 palst)
 ; Ŀ
 ;   Larne end.                                                            
 ; 

 ; Ŀ
 ;   Sonar - see if a string contains a substring.                         
 ;   Arguments:  Loc, the substring.                                       
 ;               Txt, the string.                                          
 ;               Cas, if this is non-nil then the search                   
 ;                                is non-case-sensitive.                   
 ;   Returns the number of occurrences of the substring.                   
 ; 
 (DEFUN SONAR (loc txt cas / chflg ln sta st)
  (setq chflg 0)
  (if cas 
      (progn
           (setq loc (strcase loc t))
           (setq txt (strcase txt t))))
  (setq ln (strlen loc))
  (setq sta 1)
  (while (= ln (strlen (setq st (substr txt sta ln))))
         (if (= st loc) (setq chflg (1+ chflg)))
         (setq sta (1+ sta)))
 chflg)
 ; Ŀ
 ;   Sonar end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen linn))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Vows - Capitalise only the vowels in a text string.                   
 ;   Arguments: Exstr, a string.                                           
 ;   Returns the modified string.                                          
 ;   Calls nothing.                                                        
 ; 
 (DEFUN VOWS (exstr / nustr sub)
  (setq nustr "")
  (while (and (setq sub (substr exstr 1 1))
              (/= sub ""))
         (setq exstr (substr exstr 2))
         (if (member sub '(list "a" "e" "i" "o" "u" "y"
                                "A" "E" "I" "O" "U" "Y"))
             (setq nustr (strcat nustr (strcase sub)))
             (setq nustr (strcat nustr (strcase sub t)))))
 nustr)
 ; Ŀ
 ;   Vows end.                                                             
 ; 

 ; Ŀ
 ;   Larn - convert all layer names to a different case.                   
 ; 
 (DEFUN C:LARN (/ uplor rew llist lanam gnunam)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Ask which way to go.                                                  
 ; 
 ; (initget 0 "Consonants Upper Lower Leading Vowels Alternating")
 ; (setq uplor (getkword "Consonants Upper Leading Vowels Alternating <Lowercase>: "))
 ; (if (null uplor) (setq uplor "Lower"))
 ; Ŀ
 ;   Call Larne, the dialog box handler, which returns a key string.       
 ; 
  (if (setq uplor (larne))
      (progn
 ; Ŀ
 ;   Step through the layer tables and impart rationality.                 
 ; 
           (setq rew t)
           (while (setq llist (tblnext "layer" rew))
                  (setq rew ())
                  (setq lanam (cdr (setq asoc2 (assoc 2 llist))))
                  (if (or (= 16 (logand 16 (cdr (assoc 70 llist))))
                          (= lanam "0"))
                      (write-line (strcat "Can't rename layer " lanam))
                      (progn
                           (cond ((= uplor "upper")
                                  (setq gnunam (strcase lanam)))
                                 ((= uplor "lower")
                                  (setq gnunam (strcase lanam t)))
                                 ((= uplor "leading")
                                  (setq gnunam (fdash (list " " "-" "/")
                                                       lanam)))
                                 ((= uplor "vowels")
                                  (setq gnunam (vows lanam)))
                                 ((= uplor "consonants")
                                  (setq gnunam (conso lanam)))
                                 ((= uplor "alternating")
                                  (setq gnunam (alta lanam))))
                           (command ".rename" "layer" lanam gnunam)))))
      (prompt "No Style Selected."))
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Larn end.                                                             
 ; 

 ; Ŀ
 ;   Lea - convert all layer names to lower case with initial capitals.    
 ; 
 (DEFUN C:LEA (/ rew llist lanam gnunam)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Step through the layer tables and impart rationality.                 
 ; 
  (setq rew t)
  (while (setq llist (tblnext "layer" rew))
         (setq rew ())
         (setq lanam (cdr (setq asoc2 (assoc 2 llist))))
         (if (not (or (= 16 (logand 16 (cdr (assoc 70 llist))))
                      (= lanam "0")))
             (progn
                  (setq gnunam (fdash (list " " "-" "/") lanam))
                  (command ".rename" "layer" lanam gnunam))))
  (command "undo" "end")
 (princ))